///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef _NSWFL_CONVERSION_CPP_
#define _NSWFL_CONVERSION_CPP_
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <StdIO.H>
#include <StdLib.H>

#include "NSWFL.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Bin2Hex(void *lpTarget, int iMaxSz, const void *lpSrc, int iSz, int iBytes)
{
	return Bin2Hex(lpTarget, iMaxSz, lpSrc, iSz, iBytes, true);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Bin2Hex(void *lpTarget, int iMaxSz, const void *lpSrc, int iSz, int iBytes, bool bPrefix)
{
	int iWPos = 0;
	int iRPos = 0;
	int iByte = 0;

	if(iBytes < 1)
	{
		return 0;
	}

	Assert(((iSz * iBytes) + 1) > iMaxSz, "Buffer too small.");

	if(bPrefix)
	{
		((char *)lpTarget)[iWPos++] = '0';
		((char *)lpTarget)[iWPos++] = 'x';
	}

	while(iRPos < iSz)
	{
		iByte = (iBytes-1);

        while(iByte >= 0)
		{
             ((char *)lpTarget)[iWPos++] = "0123456789ABCDEF"[((((char *)lpSrc)[iRPos] >> (iByte--)*4) & 0xF)];
        }
		iRPos++;
	}

	((char *)lpTarget)[iWPos] = '\0';

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int HexToDec(const char *sHexString)
{
	struct CHexMap
	{
		char cChar;
		int iValue;
	};

	const int iHexMapSz = 16;

	CHexMap HexMap[iHexMapSz] =
		{
			{'0', 0}, {'1', 1}, {'2', 2}, {'3', 3},
			{'4', 4}, {'5', 5}, {'6', 6}, {'7', 7},
			{'8', 8}, {'9', 9}, {'A',10}, {'B',11},
			{'C',12}, {'D',13}, {'E',14}, {'F',15}
		};

	char sAlloc[64];
	strcpy_s(sAlloc, sizeof(sAlloc), UCase((char *)sHexString));

	char *sHex = sAlloc;
	int iResult = 0;
	bool bFirstTime = true;

	if (*sHex == '0' && *(sHex + 1) == 'X')
	{
		sHex += 2;
	}

	while (*sHex != '\0')
	{
		bool bFound = false;
		for (int i = 0; i < iHexMapSz; i++)
		{
			if(*sHex == HexMap[i].cChar)
			{
				if(!bFirstTime)
				{
					iResult <<= 4;
				}
				iResult |= HexMap[i].iValue;
				bFound = true;
				break;
			}
		}

		if (!bFound)
		{
			break;
		}

		sHex++;
		bFirstTime = false;
	}

	return iResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LongChar(char *sOutVal, int iMaxSz, DWORD dwInput)
{
    _ultoa_s(dwInput, sOutVal, iMaxSz, 10);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FloatChar(char *sOutVal, int iMaxSz, float fInput, int iDecPlaces)
{
	_gcvt_s(sOutVal, iMaxSz, fInput, iDecPlaces);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FloatChar(char *sOutVal, int iMaxSz, float fInput)
{
	FloatChar(sOutVal, iMaxSz, fInput, 12);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DoubleChar(char *sOutVal, int iMaxSz, double dInput)
{
    sprintf_s(sOutVal, iMaxSz, "%.1f", dInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void IntChar(char *sOutVal, int iMaxSz, int iInput)
{
    _itoa_s(iInput, sOutVal, iMaxSz, 10);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

long CharLong(const char *sInput)
{
    return (long) atol(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

float CharFloat(const char *sInput)
{
    return (float) atof(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

double CharDouble(const char *sInput)
{
    return (double) atof(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CharInt(const char *sInput)
{
    return (int) atoi(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
